;
;	DS1820 one wire bus arbiter Version 2.01
;

; Copyright N.G. Hubbard July 1999
 
; Commercial use is not permitted, unless licensed.


; Private individual use, or educational use is not restricted.

; nick.hubbard@dial.pipex.com


; OH3NWQ - 2005-07-29 No blinking RTS light ':' instead of ',' between the bytes


; Pin configuration


;	1	A2	IN 	RTS - logic 1 to run	
;	2	A3	OUT 	LED - Reading Device
;	3	A4 	(Open Collector)
;	4	/MCLR
;	5	VSS	gnd
;	6	B0	I/O	single line bus 0 
;	7	B1	I/O	single line bus 1
;	8	B2	I/O	single line bus 2
;	9	B3	I/O	single line bus 3
;	10	B4	I/O	single line bus 4
;	11	B5	I/O	single line bus 5
;	12	B6	I/O	single line bus 6
;	13	B7	I/O	single line bus 7
;	14	VDD	+5v
;	15	OSC
;	16	OSC
;	17	A0	OUT	LED -  I'm Alive!
;	18	A1	OUT 	RS232 TX
;
; 
	LIST p=16f84
#include <p16f84a.inc>	
	__CONFIG 11h

LED_BIT		equ 0		; porta 0
LED_MASK	equ 1		; porta 0

RS232_BIT	equ 1		; porta 1
RS232_MASK	equ 2		; porta 1

RTS_BIT		equ 2		; porta 2
RTS_MASK	equ 4		; porta 2 pin 1

LEDR_BIT	equ 3		; porta 3
LEDR_MASK	equ 8		; porta 3

; RX_STATE bit mask

RX_PRES_BIT	equ 0
RX_PRES_MASK	equ 1

RX_DATA_BIT	equ 1
RX_DATA_MASK	equ 2

RX_B1_BIT	equ 2		; used when we're reading the ROM ID. This is 
RX_B1_MASK	equ 4		; the first bit read of the 3 cycle arbitration

;	note: general purpose registers begin at 0CH

LOOP0		equ	0x0c	; used by DS1820 tx and rx, housekeeper, reset all, Triread
LOOP1		equ 0x0d	; housekeeper and ReadData and temperature conversion timeout
LOOP2		equ	0x0e	; 500ms breather in main loop 
OUT_IMAGE 	equ 0x0f	; images used to update port a onlt during housekeeper
LED_DURATION 	equ 0x10	; housekeeper 500ms led duration
OUT_IND		equ	0x11	; used by DS1820 TX_BYTE
O_BYTE		equ 0x12	; used by DS1820 TX_BYTE
ROT_MASK	equ	0x13	; used to identify each single wire bus
RX_STATE	equ	0x14	; init 0 
RS232_COUNT	equ	0x15	; init 0
RS232_DATA	equ	0x16	; rs232 tx char
tric		equ	0x17	; TriRead
confcount	equ	0x18	; TriRead
addrcnt		equ 0x19	; TriRead
trictemp	equ	0x1a	; TriRead
buff0		equ	0x1b	; buffer for ram read
buff1		equ	0x1c	; ..
buff2		equ	0x1d	; ..
buff3		equ	0x1e	; ..
buff4		equ	0x1f	; ..
buff5		equ	0x20	; ..
buff6		equ	0x21	; ..
buff7		equ	0x22	; ..
buff8		equ	0x23	; ..
RX_DATA		equ	0x24	; therm device read data
	
; .. 2f

	ORG 000H	; program code to start at 000H
;
;	Port initialisation
;
	BSF STATUS, RP0			; switch to bank 1 and
					; make all bits on Portb outputs

	movlw RTS_MASK			; Only RTS is an input 
	movwf TRISA			; ... all others are outputs

	BCF OPTION_REG, NOT_RBPU	; Enable pullups on port B
	movlw 0xff			; 
	movwf TRISB			; make all PortB bits inputs

	BCF STATUS, RP0			; back to data bank 0

;	Global variable initialisation

	movlw	.1			; Start somewhere!
	movwf	ROT_MASK		; scan single wire bus 0 will be scanned first

	movlw 0x00			; 
	movwf RX_STATE			; rx state of themo

;	We return here if RTS drops during conversions

INIT1
	MOVLW RS232_MASK		; 
	movwf PORTA			; leds off, RS232 mark
	movwf OUT_IMAGE			; ..

;	Before we proceed - is RTS active?
; 	This is seen as a logic 1 on pin 1 - either the RS232 is disconnected or
;	the COM port has asserted RTS (+12v)
; 	When disconnected a 10k provides a pull up 50uA (5uA spec)

	BTFSS PORTA, RTS_BIT
	GOTO INIT1

	MOVLW 0x01			; LED toggle due
	movwf LED_DURATION

	call HouseKeeper
	call HouseKeeper

;	The program loop

Main
	call ThermConvert		; Reset all, and take temperature
	BTFSS RX_STATE, RX_PRES_BIT	; if we failed...
	goto	fakeit			; .. do a dummy delay
	call 	GetID			; read temperaures and report

; after scanning a bus take a breather for a few ms. This helps reducing the need for
; comms flow control, and stops us warming up (wearing out) the DS1820's
;
; aim to scan all 8 busses in 5 seconds 625 ms per bus

MainB

	MOVLW	.11			; 220 ms	
	MOVWF 	LOOP2
MainA
	call HouseKeeper		; this takes 20 ms(ish)
	DECFSZ	LOOP2, F; 4		; decrement and leave result in LOOP2
					; skip next statement if zero
	GOTO MainA	 

	BCF 	STATUS, C		; rotate bus mask bit to next set of devices
	rlf		ROT_MASK, f		; I'm just trying to rotate ROT_MASK not through carry!!
	btfss	STATUS, C		; ..
	goto	Main			; ..
	movlw	0x01			; ..
	movwf	ROT_MASK		; ..
	goto	Main			; ..


; we found no devices on this bus - so idle 400ms

fakeit 
	MOVLW	.20			; 400ms	
	MOVWF 	LOOP2
MainC
	call HouseKeeper		; this takes 20 ms(ish)
	DECFSZ	LOOP2, F; 4		; decrement and leave result in LOOP5
					; skip next statement if zero
	GOTO 	MainC		
	goto	MainB


;***************************************************************************
; RS232 
;***************************************************************************

DoReport
	call 	DoReport1	; report tranist buffer 0..7
	movfw	buff8
	call	outhex
NewLine
	movlw  0x0d
	call   TxChar
	movlw  0x0a
	goto   TxChar

; report transit buffer 0..7
DoReport1
	movfw	buff0
	call	outhexc
	movfw	buff1
	call	outhexc
	movfw	buff2
	call	outhexc
	movfw	buff3
	call	outhexc
	movfw	buff4
	call	outhexc
	movfw	buff5
	call	outhexc
	movfw	buff6
	call	outhexc
	movfw	buff7
outhexc
	call 	outhex
	movlw  	':'		; was comma, now colon
	goto   	TxChar
;
outhex
	movwf 	RX_DATA		; show top nibble
	swapf 	RX_DATA, W
	call 	outnibble
	movfw 	RX_DATA		; then bottom nibble
outnibble
	andlw	0x0f
	addlw	'0'
	movwf	RS232_DATA
	sublw	'9'
	btfsc   STATUS, C	; carry set if numeric
	goto	TxChar1
	movfw	RS232_DATA
	addlw	7		; make letter A..F

TxChar
	movwf  	RS232_DATA
	BTFSS	PORTA, RTS_BIT	; Check RTS!
	GOTO INIT1		; RTS false - reset (Stack will wrap!)
				; exception handler!

; We emulate a UART at 19200 baud - so take care with the timing!

TxChar1
	movlw  	.9
	movwf  	RS232_COUNT
	call 	OutZero		; start bit
	nop			; trim!
	nop
SendLp0
	decfsz RS232_COUNT, f	; 1 normally
	goto 	SendBit		; 2
	call 	bitdly1		; let data bit b7 complete
	call 	OutOne		; 2 stop bits
	call 	bitdly8		; trim stop bits
				; and fall though for second stop bit
OutOne
	bsf   	PORTA, RS232_BIT
	goto  	bitdly16

OutZero
	bcf   	PORTA, RS232_BIT; 1
	goto	bitdly16	

SendBit
	rrf  RS232_DATA, f	; 1
	btfss STATUS, C		; 1 (2)
	goto SendZero		; 2 + 26
	nop			; compenate for sendzero goto that we 
				; didn't take
	call OutOne		; send 1
	goto SendLp0

SendZero
				
	call OutZero		; 2 (call) + 24
	goto SendLp0		; 2

; 32 * 1.62 is 52
; less the overhead... we aim for a bit delay of 52us, less the call, return
; bit test logic of the caller...
; so we have 32 NOP's less some... only 18 + return (2 cycles) so that's 20 cycles

bitdly16	
	NOP
	NOP
	NOP
	NOP

	NOP
	NOP
	NOP
	NOP
bitdly8
	NOP
	NOP
	NOP
	NOP

	NOP
	NOP
	NOP
bitdly1
	nop
	RETURN


;***************************************************************************
; HouseKeeper
;***************************************************************************

; Call this any time - within reason!
; delays 20ms and flashes the led

HouseKeeper	

; Don't flash led when we have no RTS

	BTFSS	PORTA, RTS_BIT
	GOTO INIT1		; RTS false - reset (Stack will wrap!)
				; exception handler!

;	Led Flash

	decfsz	LED_DURATION, F	;	
	goto HouseKeeper1
	call LEDToggle

HouseKeeper1
	movlw .20		; 20 ms (100 ms seems to too sluggish)
	call Delay		; delay

;	Update Output Port

	movfw OUT_IMAGE		; update led and 
	movwf PORTA
	return

LEDToggle
	MOVLW .25		; New LED toggle duration 500 ms
	movwf LED_DURATION	; ..
	movfw OUT_IMAGE		; /Toggle LED image
;	xorlw LED_MASK		; LED blink
    iorlw LED_MASK		; LED on
	movwf OUT_IMAGE		; ..
	return

;***************************************************************************************

Delay	; delays for number of ms in W
	
	MOVWF 	LOOP1
	movfw 	OUT_IMAGE	; 	; update led and relay state
	movwf 	PORTA	; 
	
Outer
; delay 1 ms
; we clock at 19200 * 128 = 2.4576 MHz
; instruction period is 4/ clk = 1.62us
;
; inner loops 6 * 1.62 = 9.76 ms
; 1000/ (9.76) = 102.4

	MOVLW	.102	; close to 1.0 msec
			; 2 * 10us * 50 = 1000us
	MOVWF 	LOOP0

Inner1
	NOP		; 1
	NOP		; 2
	NOP		; 3
	DECFSZ	LOOP0, F; 4	; decrement and leave result in LOOP0
				; skip next statement if zero
	GOTO Inner1	; 5, 6

	DECFSZ 	LOOP1, F
	GOTO Outer
	RETURN

;***************************************************************************
; GetID
;***************************************************************************
;
; Identify the devices on a bus and read their temperatures
;
; note: confict count will change as different paths are chosen
;
GetID
	clrf	tric
GetIDT2
	clrf	confcount
	movfw	tric
	movwf	trictemp

	call	GetIDT1		; look for a particular device so many conflicts on
	BTFSS 	RX_STATE, RX_PRES_BIT
	return			; no device - leave

	call 	LED_On
	call 	DoReport1	; report its laser address
	call 	ThermRead	; read temperature
	call 	DoReport	; and report
	call 	HouseKeeper	; this takes 20 ms(ish)
	call 	LED_Off

	movfw	confcount	; did we have any conflicts?
	btfsc	STATUS,Z
	return
;
;	decide which way to go next time we get a conflict
;
	clrf	LOOP0
	decf	LOOP0, f	; 11111111
cook2
	rrf	LOOP0, f
	bcf	LOOP0, 7	; 01111111
	DECFSZ	confcount, f
	goto 	cook2

	movfw	LOOP0
	IORWF	tric, f
	incf	tric, f
	btfsc	STATUS,Z
	return		
	goto 	GetIDT2
	
GetIDT1
	call resetall

; if no devices, give up now.

	BTFSS RX_STATE, RX_PRES_BIT
	return

	MOVLW  0xf0      		;out f0 the search rom command
     	CALL   TX_BYTE

; read in the 64 bit ID ( 8 bytes)
; byte 	0 - dallas ID for device family
; 	1..6 unique ID
;	7 CRC 

TriRead
	MOVLW	0x40			; for all bits in sequence...	64 decimal!
	MOVWF 	addrcnt
TriRead1
	rrf  	RX_DATA, F
	bcf 	RX_DATA, 7		; clear bit
	BCF 	RX_STATE, RX_B1_BIT	; assume a read of 0
	call 	rxd			; read first response
	BTFSS 	RX_STATE, RX_DATA_BIT
	goto 	TriRead2
	BSF 	RX_STATE, RX_B1_BIT	; Ok a 1
TriRead2
	call 	rxd			; read second response

; decide how to respond

	BTFSS	RX_STATE, RX_B1_BIT	;	XX
	goto	TriQ1		; 
	BTFSC	RX_STATE, RX_DATA_BIT	;	1X
	return				; 	11 - should never get devices disabled
	goto 	TriQ10			; 	10
TriQ1	BTFSC	RX_STATE, RX_DATA_BIT	;	0X
	goto 	TriQ01

; here we have a conflict - both reads were 0

	incf	confcount, 1
	rlf	trictemp, 1		; choose the path a 1 or a 0....
	btfss	STATUS,C
	goto 	TriQ01
TriQ10
; no conflict

	bsf 	RX_DATA, 7	; set bit
	call 	TX1
	goto 	TriRead4

TriQ01
; no conflict
	call 	TX0
TriRead4
	DECF	addrcnt, F
	movfw	addrcnt		; see if its time to shift (xxxxx000)
	andlw	0x07
	btfsc	STATUS,Z
	call	ByteShift
	movfw	addrcnt		; see if its time to leave (00000000)
	btfss	STATUS,Z
	goto 	TriRead1
	return	

ByteShift
	movfw	buff1
	movwf	buff0
	movfw	buff2
	movwf	buff1
	movfw	buff3
	movwf	buff2
	movfw	buff4
	movwf	buff3
	movfw	buff5
	movwf	buff4
	movfw	buff6
	movwf	buff5
	movfw	buff7
	movwf	buff6
	movfw	RX_DATA
	movwf	buff7
	return

ThermRead
	MOVLW  0xbe     		;out command BE
     	CALL   TX_BYTE
	call ReadData
	movwf buff0
	call ReadData
	movwf buff1
	call ReadData
	movwf buff2
	call ReadData
	movwf buff3
	call ReadData
	movwf buff4
	call ReadData
	movwf buff5
	call ReadData
	movwf buff6
	call ReadData
	movwf buff7
	call ReadData
	movwf buff8
	return

ReadData
	MOVLW	8	
	MOVWF 	LOOP1
rxram1
	call rxd
	rrf  RX_DATA, F
	bcf RX_DATA, 7			; clear bit
	BTFSS RX_STATE, RX_DATA_BIT
	goto rxram2
	bsf RX_DATA, 7			; set bit
rxram2
	DECFSZ	LOOP1, F; 4		; decrement and leave result in LOOP1
	goto rxram1
	movfw RX_DATA	
	return

;
ThermConvert
;
; Get the probes to read their temperature

	call resetall

; if no devices, give up now.

	BTFSS RX_STATE, RX_PRES_BIT
	return

	MOVLW  0xcc      		;out Skip ROM command
     	CALL   TX_BYTE
	MOVLW  0x44      		;out Temperature Convert command
     	CALL   TX_BYTE

	movlw	.25			; set  up 500ms timeout
	movwf	LOOP1

rxl1
; wait for a 1 - conversion is done

	call rxd
	BTFSC RX_STATE, RX_DATA_BIT
	return
	decfsz	LOOP1,f
	goto	rxl11
;
; jammed 0 - This will prevent a shorted bus from locking us up - we will be OK on the other
; busses...
;
	BCF	RX_STATE, RX_PRES_BIT	; assume absent
	return

rxl11
	call HouseKeeper		; this takes 20 ms(ish)
	goto rxl1

;***************************************************************************
; Steamy hot DS1820 routines
;***************************************************************************

;***************************************************************************
rxd
;***************************************************************************

; rx data send a neg transistion, wait 15 us, sample, wait 45 us

	comf	ROT_MASK,w	; 00001000 11110111
	movwf   PORTB		; clear bit so we don't send out a 1 glitch
	BSF STATUS, RP0		; switch to bank 1 and
				; make all bits on Portb outputs
	CLRF TRISB		; make all PortB bits outputs
	movlw 0xff 		; then input again!
	movwf TRISB		; 1
	BCF STATUS, RP0		; 2 back to data bank 0
	nop			; 3 (10 samples == 15us)
	BCF RX_STATE, RX_DATA_BIT	; 4 assume 0 (sort of initialise while we're waiting
	NOP			; 5
	NOP			; 6
	NOP			; 7
	NOP			; 8
	movfw	PORTB
	andwf	ROT_MASK, W
	BTFSS  	STATUS, Z	
	BSF	RX_STATE, RX_DATA_BIT	; got one!
; 
; wait 45 us

	MOVLW	.5		;
	MOVWF 	LOOP0
Innerf
	NOP			; 1
	NOP			; 2
	NOP			; 3
	DECFSZ	LOOP0, F	; 4 decrement and leave result in LOOP2 
				; skip next statement if zero
	GOTO Innerf		; 5, 6
	return			;

;***************************************************************************
TX0
;***************************************************************************
	comf	ROT_MASK,w	; 00001000 11110111
	movwf   PORTB		; clear bit so we don't send out a 1 glitch
	BSF STATUS, RP0		; switch to bank 1 and
				; make all bits on Portb outputs
	CLRF TRISB		; make all PortB bits outputs
	BCF STATUS, RP0		; back to data bank 0

; wait 60 us

	MOVLW	.6	;
	MOVWF 	LOOP0
Innerd
	NOP		; 1
	NOP		; 2
	NOP		; 3
	DECFSZ	LOOP0, F; 4	; decrement and leave result in LOOP2 
				; skip next statement if zero
	GOTO Innerd	; 5, 6

; tristate

	BSF STATUS, RP0		; switch to bank 1 and
				; make them input
	movlw 0xff
	movwf TRISB		; 1
	BCF STATUS, RP0		; 2 back to data bank 0
	return			; these few cycles will set the RC recovery 

;***************************************************************************
TX1
;***************************************************************************

	comf	ROT_MASK,w	; 00001000 11110111
	movwf   PORTB		; clear bit so we don't send out a 1 glitch
	BSF STATUS, RP0		; switch to bank 1 and
				; make all bits on Portb outputs
	CLRF TRISB		; make all PortB bits outputs
	movlw 0xff		; then input again!
	movwf TRISB		; 1
	BCF STATUS, RP0		; back to data bank 0

; wait 60 us

	MOVLW	.6	;
	MOVWF 	LOOP0
Innere
	NOP		; 1
	NOP		; 2
	NOP		; 3
	DECFSZ	LOOP0, F; 4	; decrement and leave result in LOOP2 
				; skip next statement if zero
	GOTO Innere	; 5, 6
	return			;

;***************************************************************************
TX_BYTE
;***************************************************************************
     	MOVWF  	O_BYTE
     	MOVLW  	.8
     	MOVWF  	OUT_IND
TX_BYTE_1
     	RRF   	O_BYTE, F
     	BTFSS  	STATUS, C
    	GOTO   	TX_BYTE_0
     	CALL	TX1     
TX_BYTE_2
    	DECFSZ  OUT_IND, F
    	GOTO  	TX_BYTE_1
     	RETURN

TX_BYTE_0
	CALL	TX0
	GOTO	TX_BYTE_2

;***************************************************************************
resetall
;***************************************************************************

; out a zero for 720 us. The Master reset pulse.

	BCF	RX_STATE, RX_PRES_BIT	; assume absent

	comf	ROT_MASK,w	; 00001000 11110111
	movwf   PORTB		; clear bit so we don't send out a 1 glitch

	BSF STATUS, RP0		; switch to bank 1 and
				; make all bits on Portb outputs
	CLRF TRISB		; make all PortB bits outputs
	BCF STATUS, RP0		; back to data bank 0

; delay 720 us

	MOVLW	.73	; 73 * 6 * 1.62 = 712 us
	MOVWF 	LOOP0
Innera
	NOP		; 1
	NOP		; 2
	NOP		; 3
	DECFSZ	LOOP0, F; 4	; decrement and leave result in LOOP2 
				; skip next statement if zero
	GOTO Innera	; 5, 6

; listen

	BSF STATUS, RP0		; switch to bank 1 and
				; make them input
	movlw 0xff
	movwf TRISB		; 1
	BCF STATUS, RP0		; 2 back to data bank 0

; wait 60 us

	MOVLW	.6	;
	MOVWF 	LOOP0
Innerc
	NOP		; 1
	NOP		; 2
	NOP		; 3
	DECFSZ	LOOP0, F; 4	; decrement and leave result in LOOP2 
				; skip next statement if zero
	GOTO Innerc	; 5, 6

; now sample

	movfw	PORTB
	andwf	ROT_MASK, W
	BTFSC  	STATUS, Z	
	BSF	RX_STATE, RX_PRES_BIT	; got one!

; the devices - if any are present!  - will be driving the 1 bit bus for the
; next 420us max

	MOVLW	.42	; 10us * 50 = 1000us
	MOVWF 	LOOP0
Innerb
	NOP		; 1
	NOP		; 2
	NOP		; 3
	DECFSZ	LOOP0, F; 4	; decrement and leave result in LOOP2 
				; skip next statement if zero
	GOTO Innerb	; 5, 6
	return

;***************************************************************************
; monitor led on when we are talking to a specific device
;***************************************************************************

LED_On
	bsf   	PORTA, LEDR_BIT
	bsf   	OUT_IMAGE, LEDR_BIT	; just in case we call delay
	return

LED_Off
	bcf   	PORTA, LEDR_BIT; 1
	bcf   	OUT_IMAGE, LEDR_BIT
	return

;***************************************************************************
	END

